;adapted for GIMP-2 by Eddy Verlinden

(define (script-fu-Timbre_poste img drawable paper hole diameter gap marg)
		(let*	(
			(owidth (car (gimp-image-width img)))
			(oheight (car (gimp-image-height img)))
			(nw (+ diameter (+ owidth (* 2 marg))))
			(nh (+ diameter (+ oheight (* 2 marg))))
			(img2 (car (gimp-image-new nw nh RGB)))
			(layer1 (car (gimp-layer-new img2 nw nh 0 "Layer1" 100 NORMAL)))
			(nholes 0)
			(pos 0)
			(i 0)
			(dist 0)
			)

	(gimp-image-add-layer img2 layer1 0)
	(gimp-image-set-active-layer img2 layer1)
	(gimp-palette-set-background paper)
	(gimp-drawable-fill layer1 1)
	(gimp-selection-none img2)

;; calculate number of horisontal holes
	(set! nholes (/ (+ nw gap) (+ diameter gap)))
	(set! pos 0)
	(set! i 0)

;; loop horisontally
	(while (< i nholes)
		(gimp-ellipse-select img2 pos 0 diameter diameter ADD 1 0 0)
		(set! pos (+ pos diameter gap))
		(set! i (+ i 1))
	)

;; calculate number of vertical holes
	(set! nholes (/ (+ nh gap) (+ diameter gap)))
	(set! pos 0)
	(set! i 0)

;; loop vertically
	(while (< i nholes)
		(gimp-ellipse-select img2 0 pos diameter diameter ADD 1 0 0)
		(set! pos (+ pos diameter gap))
		(set! i (+ i 1))
	)

;; and fill the holes with a colour
	(gimp-palette-set-background hole)
	(gimp-edit-fill layer1 1)
	(gimp-selection-none img2)

;; and here comes the clever part:
;; offset horis and vert holes by half the diameter
	(set! dist (* -1 (/ diameter 2)))
	(gimp-drawable-offset layer1 1 0 dist dist)

;; insert old image into a new layer in img2
	(gimp-selection-all img)
	(gimp-edit-copy drawable)
	(let 	((floating-sel (car (gimp-edit-paste layer1 0))))
		(gimp-floating-sel-anchor floating-sel)
	)
;; and return command to The Gimp
	(gimp-image-clean-all img2)
	(gimp-display-new img2)
)
)

(script-fu-register "script-fu-Timbre_poste"
	"<Image>/Script-Fu/Decor/Timbre poste"
	"Script permettant d'ajouter une bordure de type timbre poste. Script original de Claes G Lindblad. Traduit en français par Fajy de apprentiphotographe.ch. Mises À Jour : www.apprentiphotographe.ch"
	"Claes G Lindblad <claesg@algonet.se>"
	"Claes G Lindblad <claesg@algonet.se> Fajy <fajy@apprentiphotographe.ch"
	"20120612"
	"*"
	SF-IMAGE "Image Active" 0
	SF-DRAWABLE "Calque Actif" 0
	SF-COLOR "Couleur de la bordure" '(255 255 255)
	SF-COLOR "Couleur des trous" '(153 153 153)
	SF-VALUE "Diamètre des perforations (en pixel)" "10"
	SF-VALUE "Ecart entre les perforations (en pixel)" "5"
	SF-VALUE "Epaisseur de la marge entre l'image et les perforations (en pixel)" "7"
)
